<?php

namespace Ignite\Core\Contracts\Files;

use Ignite\Core\Files\File;

interface FileTransmitter
{
    /**
     * Set the source file.
     *
     * @param File|FileGenerator $file
     * @return static
     */
    public function source($file): FileTransmitter;

    /**
     * Set the destination file.
     *
     * @param File $file
     * @return static
     */
    public function destination(File $file): FileTransmitter;

    /**
     * Add a file processor to the pre-processor chain.
     * These are mostly useful when we're sending a file out and want to do something to it first.
     * The source file will be copied to a temporary location for pre-processors to run against it.
     *
     * @param FileProcessor|\Closure $fileProcessor
     * @return static
     */
    public function addPreProcessor($fileProcessor): FileTransmitter;

    /**
     * Add a file processor to the post-processor chain.
     * These are mostly useful when pulling a file down and want to do something to it after we've pulled it down.
     * This could also be used to move a file on a file server to a "processed" directory after we've pulled it down.
     *
     * @param string $type
     * @param FileProcessor|\Closure $fileProcessor
     * @return static
     */
    public function addPostProcessor(string $type, $fileProcessor): FileTransmitter;

    /**
     * Transmit the file.
     *
     * @return File The file that was transmitted.
     */
    public function transmit(): File;
}
