<?php

namespace Ignite\Core\Contracts\Files;

use Ignite\Core\Files\File;
use Ignite\Core\Files\TemporaryFile;
use Illuminate\Contracts\Filesystem\FileNotFoundException;

interface FileEncrypter
{
    /**
     * Encrypt the given file to the given save file or a temporary file.
     *
     * @param File $file The file to encrypt.
     * @param ?File $saveTo Where to save the encrypted version of the file. If none given, we'll use a temporary file.
     * @return File|TemporaryFile The encrypted file.
     * @throws FileNotFoundException
     */
    public function encrypt(File $file, ?File $saveTo = null): File;

    /**
     * Decrypt the given file to the given save file or a temporary file.
     *
     * @param File $file The file to decrypt.
     * @param ?File $saveTo Where to save the decrypted version of the file. If none given, we'll use a temporary file.
     * @return File|TemporaryFile The decrypted file.
     * @throws FileNotFoundException
     */
    public function decrypt(File $file, ?File $saveTo = null): File;
}
