<?php

namespace Ignite\Core\Contracts\Entities\Filters;

/**
 * This is a QueryFilter that is tied to a permission. So, the model we're working with here will be scoped not only
 * based on a user, but also based on a permission that user is trying to use.
 */
interface QueryPermissionFilter extends QueryFilter
{
    /**
     * Set the permission this class will be working with.
     *
     * @param string $permission
     * @return QueryPermissionFilter
     */
    public function forPermission(string $permission): QueryPermissionFilter;
}
