<?php

namespace Ignite\Core\Collections;

use Illuminate\Database\Eloquent\Collection;

class PermissionsCollection extends Collection
{
    /**
     * Group a flat permission collection into one grouped by the key prefix.
     * For example: "core.dashboard.browse" has a group prefix of "core".
     *
     * @return PermissionsCollection
     */
    public function groupByKeyPrefix()
    {
        return $this->groupBy(function ($permission) {
            $parts = explode('.', $permission->key);
            return array_first($parts);
        });
    }
}
