<?php

namespace Ignite\Core\Audit;

use Ignite\Core\Entities\User;
use Ignite\Core\Entities\Participant;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Contracts\AuditDriver;
use OwenIt\Auditing\Models\Audit as AuditModel;

class ParticipantDriver extends UserDriver implements AuditDriver
{
    /**
     * @inheritDoc
     */
    public function audit(Auditable $model): \OwenIt\Auditing\Contracts\Audit
    {
        $class = config('audit.implementation', AuditModel::class);
        $audit = $model->toAudit();
        $audit['context_type'] = Participant::class;
        $audit['context_id']   = $this->getContextId($model);

        return $class::create($audit);
    }

    /**
     * Determine the context id based on model type.
     *
     * @param  Auditable $model
     * @return mixed
     */
    private function getContextId(Auditable $model)
    {
        if ($model instanceof User || $model instanceof Participant) {
            return $model->getKey();
        }

        return null;
    }
}
