@extends('Core::layouts.transaction')

@section('page_heading', 'Assign to Participant')
@section('page_breadcrumb', 'Assign to Participant')

@section('page_content')
    <div class="row">
        <div class="col-sm-4">
            <div class="box box-default">
                <div class="box-body no-padding">
                    <table class="table table-condensed table-striped">
                        <tbody>
                            <tr>
                                <th>Type</th>
                                <td>{{ ucwords(strtolower(str_replace(['-', '_'], ' ', $model->type))) }}</td>
                            </tr>
                            <tr>
                                <th>Identifier</th>
                                <td>{{ $model->identifier }}</td>
                            </tr>
                            <tr>
                                <th>Value</th>
                                <td>{{ Format::currency($model->value) }}</td>
                            </tr>
                            <tr>
                                <th>Tax Date</th>
                                <td>{{ Format::date($model->tax_date) }}</td>
                            </tr>
                            <tr>
                                <th>Transaction Date</th>
                                <td>{{ Format::date($model->transaction_date) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Transaction waiting to be assigned</h3>
                </div>
                <div class="alert alert-warning no-radius no-margin">
                    <strong>Please note, once the transaction is assigned, you cannot re-assign it to another participant.</strong>
                </div>
                <div class="box-body">
                    {!! form($form) !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script type="text/javascript" src="{{ asset('vendor/ignite/js/core/participant-lookup.js') }}"></script>
@endpush
