@extends('Core::layouts.main')

@section('meta_title', 'User Security Management')
@section('page_heading', 'Users')
@section('page_breadcrumb', 'Users')

@section('breadcrumb')
    @parent
    <li><a href="#">Security</a></li>
    <li class="active">@yield('page_breadcrumb')</li>
@endsection

@section('heading')
    <h1>
        @yield('page_heading')
        <small><a href="{{ route('admin.security.users.index') }}">Users Management</a></small>
    </h1>
@endsection

@section('page_content')
    <div class="nav-tabs-custom">
        <ul class="nav nav-tabs">
            <li class="active"><a href="{{ route('admin.security.users.index') }}">Users</a></li>
            <li><a href="{{ route('admin.security.groups.index') }}">Groups</a></li>
            <li><a href="{{ route('admin.security.permissions.index') }}">Permissions</a></li>
        </ul>
        <div class="tab-content">
            {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
        </div>
    </div>
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
@endsection
