@extends('Core::layouts.report')

@section('page_heading', 'Reports')
@section('page_breadcrumb', 'Reports')

@section('page_content')
    <div class="row">
        <div class="col-sm-12">
            <div class="box box-primary">
                <div class="box-header no-margin no-padding with-border">
                    <div class="alert alert-default no-radius no-margin text-danger">
                        <i class="icon fa-solid fa-exclamation-triangle"></i>
                        Some reports contain sensitive personal information such as Social Security Numbers.
                        By default, the sensitive information is encrypted.
                        In order to decrypt the report, please request that I.T. temporarily make it available.
                    </div>
                </div>
                <div class="box-body">
                    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function () {
            let $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons();
        });
    </script>
@endsection
