@php
    $field = $filter['field'];
    $key = md5($report->class);
    $value = session()->get($key)[$field]['value'] ?? null;
    $start = session()->get($key)[$field]['startDate'] ?? null;
    $end = session()->get($key)[$field]['endDate'] ?? null;
    $slug = \Illuminate\Support\Str::slug($field, '_');
@endphp
<div class="form-group report-filter-daterange">
    <label class="control-label col-sm-3">{{ $filter['label'] ?? 'Date' }}</label>
    <div class="col-sm-9">
        <input id="filter_{{ $slug }}" class="form-control report-filter-daterangepicker" type="text" name="filters[{{ $field }}][value]" value="{{ $value }}" />
        <input type="hidden" id="filter_{{ $slug }}_field" name="filters[{{ $field }}][field]" value="{{ $field }}" />
        <input type="hidden" id="filter_{{ $slug }}_start" name="filters[{{ $field }}][startDate]" value="{{ $start }}" />
        <input type="hidden" id="filter_{{ $slug }}_end" name="filters[{{ $field }}][endDate]" value="{{ $end }}" />
    </div>
</div>

@section('js')
    @parent
    <script type="text/javascript">
        $(document).ready(function() {
            $('#filter_{{ $slug }}').daterangepicker({
                ranges: {
                    'Last 7 Days': [moment().subtract(7, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(30, 'days'), moment()],
                    'Last 60 Days': [moment().subtract(60, 'days'), moment()],
                    'WTD': [moment().startOf('week'), moment()],
                    'MTD': [moment().startOf('month'), moment()],
                    'QTD': [moment().startOf('quarter'), moment()],
                    'YTD': [moment().startOf('year'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'This Quarter': [moment().startOf('quarter'), moment().endOf('quarter')],
                    'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')]
                },
                autoUpdateInput: false,
                opens: 'center',
                drops: 'down',
                alwaysShowCalendars: true,
            }, function(start, end, label) {
                if (! start && ! end) {
                    $('#filter_{{ $slug }}').val('');
                    $('#filter_{{ $slug }}_start').val('');
                    $('#filter_{{ $slug }}_end').val('');
                }
                if (start !== 'Invalid date' && end !== 'Invalid date') {
                    $('#filter_{{ $slug }}').val(start.format('MM/DD/YYYY') + ' - ' + end.format('MM/DD/YYYY'));
                    $('#filter_{{ $slug }}_start').val(start.format('MM/DD/YYYY'));
                    $('#filter_{{ $slug }}_end').val(end.format('MM/DD/YYYY'));
                } else  {
                    $('#filter_{{ $slug }}').val('');
                    $('#filter_{{ $slug }}_start').val('');
                    $('#filter_{{ $slug }}_end').val('');
                }
            });
            $('#report-filter-modal').on('hidden.bs.modal', function () {
                $('#filter_{{ $slug }}').data("DateTimePicker").hide();
            });
        });
    </script>
@endsection
