@if ($page->isAlias())
<div class="alert alert-warning">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
    <strong>Please Note, this page is an alias of an important system page. Management of this page will be limited.</strong>
</div>
@endif
<form id="page-editor" action="{{ $url }}" method="post" novalidate>
    {{ csrf_field() }}
    {{ method_field($method) }}
    <div class="row form-affix-container">
        <div class="col-md-9 form-affix-body">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="active"><a href="#form-content" data-toggle="tab">Content</a></li>
                    <li><a href="#form-seo" data-toggle="tab">SEO</a></li>
                    <li class="nav-tabs-custom-toolbar pull-right">
                        <div class="box-tools"></div>
                    </li>
                </ul>
                <div class="tab-content form-horizontal">
                    <div class="tab-pane active" id="form-content">
                        <div class="form-group form-text">
                            <label for="form-content-title" class="col-sm-2 control-label">Title</label>
                            <div class="col-sm-10">
                                <input autocomplete="off" type="text" name="label" class="form-control" id="form-content-title" value="{{ old('label') ? old('label') : $page->getAttribute('label') }}" placeholder="Enter the page title">
                            </div>
                        </div>
                        <div class="form-group form-text">
                            <label for="form-content-code" class="col-sm-2 control-label">URL</label>
                            <div class="col-sm-10 text slug">
                                <input autocomplete="off" name="code" type="text" {{ $page->isAlias() ? 'readonly' : '' }} class="form-control" id="form-content-code" value="{{ old('code') ? old('code') : $page->getAttribute('code') }}" placeholder="Enter the page url e.g. /example-page">
                            </div>
                        </div>
                        <div class="form-group form-editor">
                            <label for="form-content-content" class="col-sm-2 control-label">Content</label>
                            <div class="col-sm-10">
                                <textarea name="content" rows="20" class="form-control editor" id="form-content-content">{{ old('content') ? old('content') : $page->getAttribute('content') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="form-seo">
                        <div class="box-title">
                            <div class="form-group form-text">
                                <label for="form-seo-title" class="col-sm-2 control-label">Meta Title</label>
                                <div class="col-sm-10">
                                    <input name="meta_title" type="text" class="form-control" id="form-seo-title" placeholder="Enter the title for search engines">
                                </div>
                            </div>
                            <div class="form-group form-text">
                                <label for="form-seo-keywords" class="col-sm-2 control-label">Meta Keywords</label>
                                <div class="col-sm-10">
                                    <input name="meta_keywords" type="text" class="form-control" id="form-seo-keywords" placeholder="Enter the keywords for search engines">
                                </div>
                            </div>
                            <div class="form-group form-text">
                                <label for="form-seo-description" class="col-sm-2 control-label">Meta Description</label>
                                <div class="col-sm-10">
                                    <textarea name="meta_description" class="form-control" id="form-seo-description" rows="3"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3 form-affix-actions form-affix-actions--affixed">
            <div class="box box-primary">
                <div class="box-body">
                    <div class="form-group select">
                        @php
                        $selectedStatus = old('status') ?? $page->getAttribute('status');
                        @endphp
                        <label for="form-content-status">Status</label>
                        <select {{ $page->isAlias() && ! auth()->user()->hasGroup('admin') ? 'readonly disabled' : '' }} class="form-control select2" name="status" id="form-content-status">
                            @foreach($page->getStatuses() as $value => $label)
                                <option value="{{ $value }}"{{ $value == $selectedStatus ? ' selected' : '' }}>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group select">
                        @php
                        $selectedVisibility = old('display_in_menu') ?? $page->getAttribute('display_in_menu');
                        @endphp
                        <label for="form-content-display_in_menu">Display in Menu</label>
                        <select {{ $page->isAlias() && ! auth()->user()->hasGroup('admin') ? 'readonly disabled' : '' }} class="form-control select2" name="display_in_menu" id="form-content-display_in_menu">
                            @foreach($page->getMenuDisplayOptions() as $value => $label)
                                <option value="{{ $value }}"{{ $value == $selectedVisibility ? ' selected' : '' }}>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group form-date">
                        <label for="form-content-published_at">Publish Date</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                                <span class="fa-solid fa-calendar"></span>
                            </div>
                            <input {{ $page->isAlias() && ! auth()->user()->hasGroup('admin') ? 'readonly disabled' : '' }}
                                   name="published_at"
                                   type="text"
                                   class="form-control datepicker"
                                   id="form-content-published_at"
                                   placeholder="e.g. {{ now()->format('Y-m-d H:i:s') }}"
                                   value="{{ old('published_at') ? old('published_at') : optional($page->published_at)->format('Y-m-d H:i:s') ?? '' }}" />
                        </div>
                    </div>

                    @if (! $page->isAlias())
                        <div class="form-group select">
                            @php
                            $selectedTemplate = old('template') ?? $page->getAttribute('template');
                            @endphp
                            <label for="form-content-template">Template</label>
                            <select class="form-control select2" name="template" id="form-content-template">
                                @foreach (config('core.cms.templates') as $template => $label)
                                <option value="{{ $template }}"{{ $template == $selectedTemplate ? ' selected' : '' }}>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group select">
                            @php
                                $selectedType = old('program_type') ?? $page->getAttribute('program_type');
                            @endphp
                            <label for="form-content-program_type">Display for Program Type</label>
                            <select class="form-control select2" name="program_type" id="form-content-program_type">
                                @foreach ($page->getProgramTypeOptions() as $value => $label)
                                    <option value="{{ $value }}"{{ $value == $selectedType ? ' selected' : '' }}>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group checkbox">
                            @php
                            $isProtected = old('is_protected') ?? $page->getAttribute('is_protected');
                            @endphp
                            <label class="checkbox-inline">
                                <input type="hidden" name="is_protected" value="0" />
                                <input type="checkbox" id="form-content-is-protected" name="is_protected" value="1"{{ $isProtected == '1' ? ' checked' : '' }} /> Protected Page?
                            </label>
                            <div id="form-content-allowed-groups" class="form-group checkboxes{{ $isProtected == '1' ? '' : ' hide' }}">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        Select the groups with access
                                    </div>
                                    <div class="panel-body no-padding" style="padding: 0 15px !important;">
                                        @include('Core::admin.cms.partials.form.groups', compact('page'))
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
                <div class="box-footer">
                    @if (($method === 'PUT' && auth()->user()->can('core.cms.pages.update')) || ($method === 'POST' && auth()->user()->can('core.cms.pages.create')))
                    <button type="submit" class="btn btn-primary pull-right">Save Page</button>
                    @endif
                    <a href="{{ route('admin.pages.index') }}" class="btn btn-default pull-left">Cancel</a>
                </div>
            </div>
        </div>
    </div>
</form>
