@extends('Core::layouts.cms')

@section('page_heading', 'Create Block')
@section('page_breadcrumb', 'Create Block')

@section('page_content')
    @include('Core::admin.cms.partials.form.block', [
        'url' => route('admin.blocks.store'),
        'page' => $block,
        'method' => 'POST'
    ])
    @include('Core::admin.cms.partials.form.media-uploads')
    @include('Core::admin.cms.partials.form.media-modal')
@endsection

@section('js')
    @parent
    <script type="text/javascript">
        window.Laravel = window.Laravel || {};
        window.Laravel.csrfToken = "{{ csrf_token() }}";
    </script>
    <script type="text/javascript" src="{{ asset('vendor/ignite/js/cms/editor.js') }}"></script>
    <script type="text/javascript" src="{{ asset('vendor/ignite/js/cms/media-upload.js') }}"></script>
    <script type="text/javascript" src="{{ asset('vendor/ignite/js/cms/media-manager.js') }}"></script>
    <script type="text/javascript">
        window.Blocks = {};
        window.Blocks.code = $('#form-content-code').val() || '';
        window.Blocks.indexUrl = "{{ route('admin.blocks.index') }}";
        window.Blocks.createUrl = "{{ route('admin.blocks.create') }}";

        jQuery(document).ready(function($) {
            $('#page-editor').igniteEditor({
                csrfToken: window.Laravel.csrfToken,
                templateCode: window.Blocks.code
            });
        });
    </script>
@endsection
