<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // upgrade for Laravel 10
        Schema::rename('password_resets', 'password_reset_tokens');
        Schema::table('password_reset_tokens', function (Blueprint $table) {
            $table->dropIndex('password_resets_email_index');
            $table->primary('email');
        });

        Schema::table('failed_jobs', function (Blueprint $table) {
            $table->string('uuid')->unique()->after('id');
        });

        Schema::table('core_user', function (Blueprint $table) {
            $table->timestamp('email_verified_at')->nullable()->after('email');
        });

        Schema::table('sessions', function (Blueprint $table) {
            $table->longText('payload')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::rename('password_reset_tokens', 'password_resets');
        Schema::table('password_resets', function (Blueprint $table) {
            $table->dropPrimary('password_reset_tokens_email_primary');
            $table->index('email');
        });

        Schema::table('failed_jobs', function (Blueprint $table) {
            $table->dropColumn('uuid');
        });

        Schema::table('core_user', function (Blueprint $table) {
            $table->dropColumn('email_verified_at');
        });

        Schema::table('sessions', function (Blueprint $table) {
            $table->text('payload')->change();
        });
    }
};
