<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateImportTable extends Migration
{
    /** @var string */
    private $tableName = 'core_import';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->string('type');
            $table->string('label')->nullable();
            $table->string('file')->nullable();
            $table->string('log')->nullable();
            $table->string('disk')->nullable()->default('local');
            $table->integer('records')->unsigned()->nullable()->default(0);
            $table->integer('imported')->unsigned()->nullable()->default(0);
            $table->integer('rejected')->unsigned()->nullable()->default(0);
            $table->integer('status')->unsigned()->nullable()->default(0);
            $table->integer('created_by')->unsigned();
            $table->integer('run_by')->unsigned()->nullable();
            $table->timestamp('run_at')->nullable();
            $table->timestamps();
            $table->index(['label']);
            $table->foreign('created_by')->references('user_id')->on('core_user')->onUpdate('cascade');
            $table->foreign('run_by')->references('user_id')->on('core_user')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists($this->tableName);
    }
}
