<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use Ignite\Core\Entities\Participant;
use Ignite\Core\Entities\User;

$factory->define(Participant::class, function (\Faker\Generator $faker, array $attributes) {
    $user = $attributes['user_id'] ?? false
            ? User::query()->find($attributes['user_id'])
            : factory(User::class, 1)->create()->first();

    return [
        "user_id" => $user->user_id,
        "title" => null,
        "email" => $user->email,
        "first" => $user->first,
        "last" => $user->last,
        "type" => "Account Executive",
        "phone1" => $faker->phoneNumber,
        "address_1" => $faker->streetAddress,
        "address_2" => null,
        "city" => $faker->city,
        "state" => $faker->stateAbbr,
        "postal" => $faker->postcode,
        "country" => 'US',
        "status" => $user->status,
        "archived" => 0,
        "internal" => $user->internal,
        "internal_notes" => null,
        "approved_at" => $faker->date('Y-m-d H:i:s'),
        "created_at" => $faker->date('Y-m-d H:i:s'),
        "updated_at" => $faker->date('Y-m-d H:i:s'),
    ];
});

$factory->state(Participant::class, 'external', ['internal' => 0]);
