<?php

namespace Ignite\Core\Tests\Unit\Files\Processors;

use Ignite\Core\Files\File;
use Ignite\Core\Files\Processors\ToImportFile;
use Ignite\Core\Services\Importers\Participants;
use Ignite\Core\Tests\TestCase;
use Illuminate\Support\Facades\Storage;

class ToImportFileTest extends TestCase
{
    protected function setUp(): void
    {
        parent::setUp();
        Storage::fake(config('core.import.disk'));
    }

    /** @test */
    public function converts_the_file_to_an_import_file()
    {
        // Arrange
        $file = new File('SomeFile.txt');
        $file->put('some contents!!');

        // Execute
        $processedFile = ToImportFile::forType(Participants::class)->run($file);

        // Check
        $file->assertMissing();
        $this->assertMatchesRegularExpression('#'.config('config.import.directory').'/.*\d+\.csv#', $processedFile->getRelativePath());
        $this->assertEquals('some contents!!', $processedFile->get());
    }

    /** @test */
    public function keeps_the_original_file_if_asked()
    {
        // Arrange
        $file = new File('OriginalFile.txt');
        $file->put('some contents!!');

        // Execute
        ToImportFile::forType(Participants::class)
            ->keepOriginal()
            ->run($file);

        // Check
        $file->assertExists();
    }

    /** @test */
    public function keeps_the_original_file_if_it_is_the_import_file()
    {
        // Arrange
        $file = new File('OriginalFile.txt');
        $file->put('some contents!!');
        $importFile = ToImportFile::forType(Participants::class)->run($file);

        // Execute
        $importFile2 = ToImportFile::forType(Participants::class)
            ->keepOriginal(false)
            ->run($importFile);

        // Check
        $file->assertMissing();
        $importFile->assertExists();
        $importFile2->is($importFile);
    }
}
