<?php

namespace Ignite\Core\Tests\Unit\Files\Processors;

use Ignite\Core\Files\File;
use Ignite\Core\Files\Processors\DeleteFileProcessor;
use Ignite\Core\Tests\TestCase;
use Illuminate\Support\Facades\Storage;

class DeleteFileProcessorTest extends TestCase
{
    /** @test */
    public function deletes_a_file()
    {
        // Arrange
        Storage::fake('an-sftp');
        $file = new File('dir1/my-file.txt', 'an-sftp');
        $file->put('test');

        // Pre-check
        $file->assertExists();

        // Execute
        (new DeleteFileProcessor())->run($file);

        // Arrange
        $file->assertMissing();
    }
}
