<?php

namespace Ignite\Core\Tests\Unit\Entities\Filters;

use Ignite\Core\Entities\Filters\NullQueryPermissionFilter;
use Ignite\Core\Entities\Group;
use Ignite\Core\Entities\Participant;
use Ignite\Core\Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;

class NullPermissionFilterTest extends TestCase
{
    use RefreshDatabase;

    /** @test */
    public function does_not_affect_queries()
    {
        // Arrange
        /** @var NullQueryPermissionFilter $permissions */
        $permissions = app(NullQueryPermissionFilter::class)->forPermission('anything.here');
        $query = Participant::query();

        // Execute & Check
        $this->assertEquals($query->toSql(), $permissions->apply($query)->toSql());
        $this->assertEquals($query->getBindings(), $permissions->apply($query)->getBindings());
    }

    public function can_access_everything()
    {
        // Arrange
        /** @var NullQueryPermissionFilter $permissions */
        $permissions = app(NullQueryPermissionFilter::class)->forPermission('anything.here');

        // Execute & Check
        $this->assertTrue($permissions->canAccess(new Participant()));
    }

    public function is_for_all_model_classes()
    {
        // Arrange
        /** @var NullQueryPermissionFilter $permissions */
        $permissions = app(NullQueryPermissionFilter::class)->forPermission('anything.here');

        // Execute & Check
        try {
            $permissions->assertForTable(new Participant());
            $permissions->assertForTable(new Group());
        } catch (\Exception $exception) {
            $this->fail('Should have no thrown exceptions. '.get_class($exception).' was thrown.');
        }
    }
}
