<?php

namespace Ignite\Core\Validators;

use Illuminate\Contracts\Validation\Validator;

class NoRepeatCharacters
{
    /**
     * Validate the value isn't just one key held down.
     *
     * @param  string    $attribute
     * @param  string    $value
     * @param  array     $parameters
     * @param  Validator $validator
     * @return bool
     */
    public function validate($attribute, $value, $parameters, $validator)
    {
        $limit = $parameters[0] ?? 10;
        return ! preg_match('/(.)\\1{'.$limit.',}/', $value, $matches);
    }
}
