<?php

namespace Ignite\Core\Models\Seeds;

use Ignite\Core\Entities\Setting;

class SettingSeeder extends BaseSeeder
{
    /** @var string */
    protected $json = 'setting';

    /**
     * Seed the database table.
     *
     * @throws \Exception
     */
    public function seed()
    {
        $settings = $this->parser->parse($this->path());

        foreach ($settings as $setting) {
            $this->seedSetting($setting);
        }
    }

    /**
     * Seed a table record.
     *
     * @param  array $setting
     * @return Setting
     */
    private function seedSetting($setting)
    {
        return Setting::updateOrCreate(['key' => $setting['key']], $setting);
    }
}
