<?php

namespace Ignite\Core\Models\Import\Hashers;

use Ignite\Core\Contracts\Imports\ImportHasher;

class TransactionHasher implements ImportHasher
{
    /**
     * @inheritdoc
     */
    public function hash(array $data)
    {
        return sha1(sprintf(
            '%s.%s.%s.%s',
            $data['identifier'],
            $data['value'],
            $data['description'],
            $data['type']
        ));
    }
}
