<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Facades\Format;

class TransactionFormatter extends Formatter
{
    /**
     * The balance of transactions for the user.
     *
     * @param object $model
     * @return string
     */
    public function balance($model)
    {
        return $this->html(Format::balance($model->value));
    }

    /**
     * The user id.
     *
     * @param \Ignite\Core\Entities\Transaction $model
     *
     * @return string
     */
    public function idWithLinkToUser($model)
    {
        return $model->user_id;
    }

    /**
     * The email address.
     *
     * @param \Ignite\Core\Entities\Transaction $model
     *
     * @return string
     */
    public function emailWithLinkToUser($model)
    {
        return $model->email;
    }

    /**
     * The transaction date.
     *
     * @param \Ignite\Core\Entities\Transaction $model
     *
     * @return \Illuminate\Support\HtmlString
     */
    public function transactionDate($model)
    {
        return $this->formatDate($model, 'transaction_date', 'Y-m-d H:i:s');
    }
}
