<?php

namespace Ignite\Core\Models\Dashboard\Charts;

use Ignite\Core\Contracts\Dashboard\WithInlineSeries;
use Ignite\Core\Contracts\Dashboard\WithPercentageChange;
use Ignite\Core\Models\Dashboard\Concerns\DeterminesPercentageChange;
use Ignite\Core\Services\Google\Analytics\Client;

class PageviewsStat extends BaseGoogleAnalyticsMetric implements WithInlineSeries, WithPercentageChange
{
    use DeterminesPercentageChange;

    /**
     * {@inheritdoc}
     */
    public function __construct(Client $analytics, $attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Pageviews',
        ], $attributes);

        parent::__construct($analytics, $attributes);
    }

    /**
     * {@inheritdoc}
     *
     * @return static
     */
    public function setSeries(array $data)
    {
        $this->offsetSet('series', array_map(function ($value) {
            return (empty($value)) ? 0 : $this->decorate($value);
        }, $data));

        return $this;
    }

    /**
     * {@inheritdoc}
     *
     * @return static
     */
    public function setPercentageChange($current, $previous)
    {
        $this->offsetSet('current', $this->decorate($current));
        $this->offsetSet('previous', $this->decorate($previous));
        $this->offsetSet('direction', $this->determineChangeType($current, $previous));
        $this->offsetSet('percentage', $this->determinePercentageChange($current, $previous));

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function getElement()
    {
        return $this->get('key', 'pageviews-stat');
    }

    /**
     * {@inheritdoc}
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }

    /**
     * {@inheritdoc}
     */
    public function getData()
    {
        if (Client::VERSION_UA == $this->analytics->getVersion()) {
            return $this->prepareData('pageviews');
        } else {
            return $this->prepareData('screenPageViews');
        }
    }

    /**
     * {@inheritdoc}
     */
    protected function decorate($value)
    {
        return number_format($value);
    }
}
