<?php

namespace Ignite\Core\Listeners;

use Ignite\Core\Entities\User;
use Ignite\Core\Events\EnrollmentComplete;
use Illuminate\Auth\Events\PasswordReset;

class CompleteEnrollment
{
    /**
     * When a user sets a password.
     *
     * @param PasswordReset $event
     */
    public function handle(PasswordReset $event)
    {
        if ($event->user->isPending()) {
            $event->user->status = User::STAT_ACTIVE;

            if (! $event->user->relationLoaded('participant')) {
                $event->user->load('participant');
            }

            $event->user->participant->update([
                'status' => User::STAT_ACTIVE
            ]);

            event(new EnrollmentComplete($event->user));

            $event->user->save();
        }
    }
}
