<?php

namespace Ignite\Core\Files\Processors;

use Ignite\Core\Contracts\Files\FileProcessor;
use Ignite\Core\Files\File;

class AdhocFileProcessor implements FileProcessor
{
    /**
     * @var \Closure
     */
    protected $closure;

    public function __construct(\Closure $closure)
    {
        $this->closure = $closure;
    }

    /**
     * {@inheritdoc}
     */
    public function run(File $file): File
    {
        return ($this->closure)($file);
    }
}
