<?php

namespace Ignite\Core\Entities;

use Illuminate\Database\Eloquent\Builder;

/**
 * Ignite\Core\Entities\Transaction
 *
 * @property int $id
 * @property int $user_id
 * @property int $related_id
 * @property string|null $related_type
 * @property string $type
 * @property string|null $description
 * @property float|null $value
 * @property string|null $notes
 * @property string|null $tax_date
 * @property string|null $related_name
 * @property string|null $batch_id
 * @property string|null $hash
 * @property string $transaction_date
 * @property string|null $deleted_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Ignite\Core\Entities\Participant $participant
 * @method static Builder|Transaction byCurrentUser()
 * @method static Builder|Transaction byUser($user)
 * @method static Builder|Transaction newModelQuery()
 * @method static Builder|Transaction newQuery()
 * @method static Builder|Transaction query()
 * @method static Builder|Transaction whereBatchId($value)
 * @method static Builder|Transaction whereCreatedAt($value)
 * @method static Builder|Transaction whereDeletedAt($value)
 * @method static Builder|Transaction whereDescription($value)
 * @method static Builder|Base whereHasPermission(string $permission, ?\Ignite\Core\Entities\User $user = null)
 * @method static Builder|Transaction whereHash($value)
 * @method static Builder|Transaction whereId($value)
 * @method static Builder|Transaction whereNotes($value)
 * @method static Builder|Transaction whereRelatedId($value)
 * @method static Builder|Transaction whereRelatedName($value)
 * @method static Builder|Transaction whereRelatedType($value)
 * @method static Builder|Transaction whereTaxDate($value)
 * @method static Builder|Transaction whereTransactionDate($value)
 * @method static Builder|Transaction whereType($value)
 * @method static Builder|Transaction whereUpdatedAt($value)
 * @method static Builder|Transaction whereUserId($value)
 * @method static Builder|Transaction whereValue($value)
 * @mixin \Eloquent
 */
class Transaction extends Base
{
    public const EARNED = 'EARNED';
    public const REDEEMED = 'REDEEMED';
    public const CANCELLED = 'CANCELLED';
    public const MANUAL_RECEIVE = 'MANUAL-RECEIVE';
    public const MANUAL_REDEEM = 'MANUAL-REDEEM';
    public const EXPIRED = 'EXPIRED';
    public const RESET = 'RESET';
    public const RETURN = 'RETURN';

    /**
     * The name of the table.
     *
     * @var string
     */
    protected $table = 'core_transaction';

    /**
     * The transaction types
     * @var array
     */
    protected $types = [
        // System applied
        'CANCELLED',
        'EARNED',
        'REDEEMED',
        // Manually applied
        'MANUAL-RECEIVE',
        'MANUAL-REDEEM',
        // Not implemented
        'EXPIRED',
        'RESET',
        'RETURN',
    ];

    /**
     * The default types.
     *
     * @return array
     */
    public function getTypes()
    {
        return $this->types;
    }

    /**
     * The participant associated with the transaction.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function participant()
    {
        return $this->belongsTo(Participant::class, 'user_id', 'user_id');
    }

    /**
     * Scope a query to the current user.
     *
     * @param Builder $query
     * @return Builder
     */
    public function scopeByCurrentUser(Builder $query)
    {
        $query->where('user_id', auth()->user()->getKey());

        return $query;
    }

    /**
     * Scope a query to the current user.
     *
     * @param Builder $query
     * @param User|int $user
     * @return Builder
     */
    public function scopeByUser(Builder $query, $user)
    {
        if ($user instanceof User || $user instanceof Participant) {
            $query->where('user_id', $user->getKey());
        } else {
            $query->where('user_id', $user);
        }


        return $query;
    }
}
