<?php

namespace Ignite\Core\Contracts\Repositories;

use Ignite\Core\Entities\User;

interface UserRepository
{
    /**
     * The scoped User query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query();

    /**
     * Find a user by primary key.
     *
     * @param int $id
     * @return \Ignite\Core\Entities\User
     */
    public function find($id);

    /**
     * Assign the provided groups to the given user.
     *
     * @param $id
     * @param array $groups
     * @return \Ignite\Core\Entities\User
     */
    public function assignGroups($id, array $groups);

    /**
     * Activate a user.
     *
     * @param int $id
     * @return \Ignite\Core\Entities\User
     */
    public function activate($id);

    /**
     * Deactivate a user.
     *
     * @param int $id
     * @return \Ignite\Core\Entities\User
     */
    public function deactivate($id);

    /**
     * Find the admin user for the system.
     * (see core.admin config)
     *
     * @return User|null
     */
    public function findAdminUser(): ?User;
}
