<?php

namespace Ignite\Core\Contracts;

interface CanDisplayInMenu
{
    /**
     * Set the url of the view page.
     *
     * @param  string $url
     * @return $this
     */
    public function setUrl($url);

    /**
     * The url of the view page.
     *
     * @return string
     */
    public function getUrl();

    /**
     * Set the icon to show along with the label.
     *
     * @param  string $icon
     * @return $this
     */
    public function setIcon($icon);

    /**
     * The icon to show along with the label.
     *
     * @return string
     */
    public function getIcon();

    /**
     * Set the page name label.
     *
     * @param  string $label
     * @return $this
     */
    public function setLabel($label);

    /**
     * The page name label.
     *
     * @return string
     */
    public function getLabel();

    /**
     * Set the position of the page in the menu.
     *
     * @param  int $position
     * @return $this
     */
    public function setPosition($position);

    /**
     * The position of the page in the menu.
     *
     * @return int
     */
    public function getPosition();

    /**
     * Set whether the item be viewed in the menu.
     *
     * @param  bool $flag
     * @return $this
     */
    public function setCanBeViewed($flag);

    /**
     * Can the item be viewed in the menu.
     *
     * @return bool
     */
    public function canBeViewed();

    /**
     * Determine if the item has child items.
     *
     * @return bool
     */
    public function hasChildren();

    /**
     * Get the child items collection.
     *
     * @return \Illuminate\Support\Collection
     */
    public function getChildren();

    /**
     * Get the value used to key the item in a collection.
     *
     * @return string
     */
    public function getMenuKey();
}
