<?php

namespace Ignite\Core\Collections;

use Illuminate\Database\Eloquent\Collection;

class GroupsCollection extends Collection
{
    /**
     * The groups highest access level is the lowest number.
     *
     * @return int
     */
    public function getHighestAccess()
    {
        return (int) $this->min('level');
    }

    /**
     * The groups lowest access level is the highest number.
     *
     * @return int
     */
    public function getLowestAccess()
    {
        return $this->max('level');
    }
}
