@php
    $user = auth()->user();
    $name = $user->fullName();
@endphp
<li class="dropdown user user-menu">
    <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
        <img src="https://ui-avatars.com/api/?background=0D8ABC&color=ffffff&name={{ urlencode($name) }}" class="user-image" alt="{{ $name }}">
        <span class="hidden-xs">{{ $name }}</span>
    </a>
    <ul class="dropdown-menu">
        <li class="user-header">
            <img src="https://ui-avatars.com/api/?background=0D8ABC&color=ffffff&name={{ urlencode($name) }}" class="img-circle" alt="{{ $name }}">
            <p>
                {{ $name }}
                <small>{{ $user->getHighestLevelGroup()->name }} &middot; {{ __('Created') }} {{ $user->created_at->format('M j, Y') }}</small>
            </p>
        </li>
        <li class="user-footer">
            <div class="pull-left">
                <a href="{{ $user->participant->getEditUserUrl($user) }}" class="btn btn-default btn-flat">
                    <i class="fa-solid fa-fw fa-user"></i> {{ __('Profile') }}
                </a>
            </div>
            <div class="pull-right">
                <a href="{{ route('admin.session.destroy') }}" class="btn btn-default btn-flat">
                    <i class="fa-solid fa-fw fa-power-off"></i> {{ __('Logout') }}
                </a>
            </div>
        </li>
    </ul>
</li>
