@extends('Core::layouts.transaction')

@section('page_heading', 'Transactions')
@section('page_breadcrumb', 'Transactions')

@section('page_content')
    <div class="row">
        <div class="col-sm-12">
            <div class="box box-primary">
                <div class="box-body">
                    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons({
                buttons: [{
                    text: '<span class="fa-solid fa-plus text-success"></span> <span class="text-success">Create</span>',
                    action: function (e) {
                        e.preventDefault();
                        window.location.href = '{{ route('admin.transactions.create') }}';
                    }
                }]
            });
        });
    </script>
@endsection
