@extends('Core::layouts.peripheral')

@section('page_title', 'Ignite Admin Login')

@section('content')
    <p class="login-box-msg">Sign in to start your session</p>

    @if ($errors->has('status'))
    <div class="alert alert-danger">
        <strong>{{ $errors->first('status') }}</strong>
    </div>
    @endif

    <form action="{{ route('admin.session.store') }}" method="post">
        {{ csrf_field() }}
        <div class="form-group has-feedback">
            <input type="text" class="form-control" name="username" placeholder="Login" value="{{ old('username') }}" maxlength="255" autofocus>
            <span class="fa-solid fa-envelope form-control-feedback"></span>
            @if ($errors->has('username'))
                <span class="help-block">
                      <span class="text-danger">{{ $errors->first('username') }}</span>
                </span>
            @endif
        </div>
        <div class="form-group has-feedback">
            <input type="password" class="form-control" name="password" placeholder="Password">
            <span class="fa-solid fa-lock form-control-feedback"></span>
            @if ($errors->has('password'))
                <span class="help-block">
                    <span class="text-danger">{{ $errors->first('password') }}</span>
                </span>
            @endif
        </div>
        <div class="row">
            <div class="col-xs-8">
                <div class="checkbox">
                    <label>
                        <input type="checkbox" name="remember" value="1" /> Remember Me
                    </label>
                </div>
            </div>
            <div class="col-xs-4">
                <button type="submit" class="btn btn-primary btn-block btn-flat">Sign In</button>
            </div>
        </div>
    </form>
@endsection
