;(function ($, window, document, undefined) {

    'use strict';

    var pluginName = "deleteEntry",
        defaults = {
            className: '.delete-entry',
            confirmation: 'Are you sure?',
            background: '#f2dede',
            data: {},
            request: {
                method: 'DELETE',
                type: 'json'
            },
            response: {
                status: 'status',
                message: 'message',
                success: 'success',
                error: 'error'
            },
            flash: {
                timeout: 3000
            },
            onSuccess: function() {},
            onError: function() {}
        };

    function Plugin(element, options) {
        this.element = element;
        this.settings = $.extend({}, defaults, options);
        this._name = pluginName;
        this._defaults = defaults;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function() {
            var self = this;
            $(document).on('click', this.settings.className, function (e) {
                e.preventDefault();
                self.handle.apply(self, [e, $(this)]);
            });
        },
        handle: function(e, button) {
            var url = button.attr('href') || this.settings.request.url;
            var message = button.data('message') || this.settings.confirmation;
            var data = this.data(button);

            if (window.confirm(message)) {
                $.ajax(this.request(url, data, button));
            }
        },
        request: function(url, data, button) {
            return {
                url: url,
                type: this.settings.request.method,
                dataType: this.settings.request.type,
                data: data,
                success: $.proxy(this.onSuccess, this, button, data),
                error: $.proxy(this.onError, this, button, data)
            };
        },
        data: function(button) {
            return (typeof this.settings.data === 'function') ? this.settings.data.apply(this, [button]) : this.settings.data;
        },
        onSuccess: function(button, data, result) {
            if (
                ! result.hasOwnProperty(this.settings.response.status) ||
                ! result.hasOwnProperty(this.settings.response.message)
            ) {
                window.location.reload();
            }

            if (result.status === this.settings.response.success) {
                this.settings.onSuccess.apply(this, [button, result, data]);
            }

            window.Ignite.Core.flash(result.message, result.status, this.settings.flash.timeout);
        },
        onError: function(button, data, errors) {
            if (errors.responseJSON.hasOwnProperty(this.settings.response.message)) {
                window.Ignite.Core.flash(
                    errors.responseJSON.message,
                    this.settings.response.error,
                    this.settings.flash.timeout
                );
            }

            this.settings.onError.apply(this, [button, errors, data]);
        }
    });

    $.extend({
        deleteEntry: function(options) {
            return new Plugin(this, options);
        }
    });

})(jQuery, window, document);
