<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransactionResourceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('core_transaction_resource', function (Blueprint $table) {
            $table->increments('id');
            $table->string('identifier', 255)->nullable()->default(null);
            $table->unsignedInteger('related_id')->nullable()->index();
            $table->string('related_type', 255)->nullable()->default(null);
            $table->string('type', 50)->nullable()->default('')->index();
            $table->string('description')->nullable()->default(null);
            $table->double('value')->nullable()->default(null)->index();
            $table->text('notes')->nullable()->default(null);
            $table->timestamp('tax_date')->nullable()->default(null);
            $table->string('related_name', 50)->nullable()->default(null);
            $table->dateTime('transaction_date')->nullable()->index();
            $table->string('hash')->nullable()->index();
            $table->softDeletes('deleted_at');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('core_transaction_resource');
    }
}
