<?php

namespace Ignite\Core\Models\Dashboard;

use Ignite\Core\Contracts\Dashboard\Donut as DonutInterface;

abstract class Donut extends Chart implements DonutInterface
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        parent::__construct(array_merge([
            'element' => $this->getElement(),
            'size' => 'col-xs-12 col-sm-6 col-md-4 col-lg-3'
        ], $attributes ?? []));
    }

    /**
     * The color of the stat.
     *
     * @return array
     */
    public function getColors()
    {
        if (empty($this->offsetGet('colors'))) {
            $this->offsetSet('colors', [
                $this->colorToHex('primary'),
                $this->colorToHex('aqua'),
                $this->colorToHex('navy'),
                $this->colorToHex('teal'),
            ]);
        }

        return array_map(function ($color) {
            return $this->colorToHex($color, $color);
        }, $this->get('colors'));
    }

    /**
     * The HTML class of an icon.
     *
     * @return string
     */
    public function getIcon()
    {
        return $this->get('icon');
    }


    /**
     * The simple name of the type of stat.
     *
     * @return string
     */
    public function getType()
    {
        return 'donut';
    }
}
