@php /** @var \Ignite\Core\Entities\Page $page */ @endphp
<li id="page-{{ $page->getKey() }}-container" class="nav-stacked-row">
    <div id="page-{{ $page->getKey() }}" class="nav-stacked-item">
        <span class="nav-stacked-drag">
            @if (! $page->isAlias())
            <span class="fa-solid fa-arrows"></span>
            @endif
        </span>
        <a href="{{ $page->getEditUrl() }}" class="nav-stacked-title">{{ $page->getLabel() }}</a>
        <span class="nav-stacked-menu text-muted pull-right">
            <a href="{{ $page->getUrl() }}"><span class="fa-solid fa-globe"></span></a>
        </span>
        <span class="nav-stacked-menu text-muted pull-right">
            @if ($page->isDisplayedInMenu())
            <span class="fa-solid fa-eye"></span>
            @else
            <span class="fa-solid fa-eye-slash"></span>
            @endif
        </span>
        <span class="nav-stacked-status pull-right">
        @if ($page->isActive())
            <span class="text-sm">Active</span>
            <span class="fa-solid fa-circle text-green"></span>
        @else
            <span class="text-sm">Inactive</span>
            <span class="fa-solid fa-circle text-muted"></span>
        @endif
        </span>
    </div>
</li>