<?php

namespace Ignite\Core\Services\Participant;

use Ignite\Core\Contracts\Participant\FactoryStrategy;
use Ignite\Core\Contracts\Entities\Participant;
use Ignite\Core\Services\Participant\Strategy\DefaultStrategy;
use Ignite\Core\Models\Data\UserParticipant;
use Illuminate\Config\Repository;
use Illuminate\Support\Fluent;

class Factory
{
    /**
     * @var Repository
     */
    private $config;

    /**
     * Factory constructor.
     *
     * @param Repository $config
     */
    public function __construct(Repository $config)
    {
        $this->config = $config;
    }

    /**
     * Make a new instance of a Factory driver.
     *
     * @param Fluent $data
     * @param Participant|null $model
     *
     * @return UserParticipant
     */
    public function make(Fluent $data, Participant|null $model = null)
    {
        $driver = $this->config->get('core.participant.factory.strategy', $this->getDefaultStrategy());

        /** @var FactoryStrategy $instance */
        $instance = app($driver);

        return $instance->make($data, $model);
    }

    /**
     * The default strategy when none has been configured.
     *
     * @return string
     */
    protected function getDefaultStrategy()
    {
        return DefaultStrategy::class;
    }
}
