<?php

namespace Ignite\Core\Providers;

use Ignite\Core\Console\DailyTransactionsBatchedEmail;
use Ignite\Core\Console\Data;
use Ignite\Core\Console\DecryptColumnCommand;
use Ignite\Core\Console\Dev;
use Ignite\Core\Console\HealthChecks;
use Ignite\Core\Console\ImportCommand;
use Ignite\Core\Console\Mail;
use Illuminate\Support\ServiceProvider;

class ConsoleServiceProvider extends ServiceProvider
{
    protected $defer = false;

    /**
     * The available commands
     *
     * @var array
     */
    protected $commands = [
        DailyTransactionsBatchedEmail::class,
        Data\Decrypt::class,
        Data\Encrypt::class,
        DecryptColumnCommand::class,
        Dev\CreateParticipant::class,
        Dev\InstallFavIcon::class,
        Dev\OverrideClass::class,
        Dev\PostSetupGit::class,
        HealthChecks\HorizonCheck::class,
        ImportCommand::class,
        Mail\Test::class,
    ];

    /**
     * Register the commands.
     */
    public function register()
    {
        $this->commands($this->commands);
    }

    /**
     * The classes the provider provides.
     *
     * @return array
     */
    public function provides()
    {
        return $this->commands;
    }
}
