<?php

namespace Ignite\Core\Emails;

use Ignite\Core\Entities\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Password;

class Enrolled extends Mailable
{
    use Queueable;
    use SerializesModels;

    /** @var User */
    protected $user;

    /**
     * Create a new order submitted message instance.
     *
     * @param User $user
     */
    public function __construct($user)
    {
        $this->user = $user;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $user = $this->user;
        $passwordUrl = $this->getPasswordUrl();

        $this->to($user->email, $user->fullName());
        $this->subject(config('core.participant.emails.enrollment.subject'));
        $this->from(config('mail.from.address'), config('mail.from.name'));

        return $this->markdown(
            config('core.participant.emails.enrollment.template'),
            compact('user', 'passwordUrl')
        );
    }

    /**
     * Get the set password url.
     *
     * @return string
     */
    protected function getPasswordUrl()
    {
        return route('password.reset', [
            'token' => Password::createToken($this->user),
            'email' => $this->user->email,
            'utm_source' => 'notification',
            'utm_medium' => 'email',
            'utm_campaign' => 'complete_enrollment'
        ]);
    }
}
