<?php

namespace Ignite\Core\Contracts\Repositories;

interface PermissionRepository
{
    /**
     * The scoped Permission query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query();

    /**
     * Find a permission by primary key.
     *
     * @param  int $id
     * @return \Ignite\Core\Entities\Permission
     */
    public function find($id);

    /**
     * Find a permission by key.
     *
     * @param  int $key
     * @return \Ignite\Core\Entities\Permission
     */
    public function findByKey($key);

    /**
     * Find all permissions in the system.
     *
     * @return \Ignite\Core\Collections\PermissionsCollection
     */
    public function findAll();

    /**
     * Create a new permission.
     *
     * @param  array $data
     * @return \Ignite\Core\Entities\Permission
     */
    public function create(array $data);

    /**
     * Update an existing permission.
     *
     * @param  int $id
     * @param  array $data
     * @return \Ignite\Core\Entities\Permission
     */
    public function update($id, array $data);

    /**
     * Delete a permission.
     *
     * @param  int $id
     * @return \Ignite\Core\Entities\Permission
     */
    public function delete($id);

    /**
     * Delete multiple permissions in one batch request.
     *
     * @param  array $ids
     * @return array
     */
    public function deleteMany(array $ids);

    /**
     * Flush the permission cache.
     *
     * @return \Ignite\Core\Auth\Authorization
     */
    public function flush();
}
