<?php

namespace Ignite\Core\Console\Dev;

use Illuminate\Console\Command;
use Symfony\Component\Console\Input\InputArgument;
use ZipArchive;

class InstallFavIcon extends Command
{
    /**
     * @var string
     */
    protected $name = 'ignite:dev:favicon';

    /**
     * @var string
     */
    protected $description = 'Unzips the favicon zip file and places it into the public folder.';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $zipPath = $this->argument('path');
        
        if (!file_exists($zipPath)) {
            $this->error("The specified zip file does not exist: {$zipPath}");
            return 1;
        }

        $zip = new ZipArchive();
        $result = $zip->open($zipPath);

        if ($result !== true) {
            $this->error("Failed to open zip file: {$zipPath}");
            return 1;
        }

        $publicPath = public_path();
        if (!$zip->extractTo($publicPath)) {
            $this->error("Failed to extract zip file to: {$publicPath}");
            $zip->close();

            return 1;
        }

        $zip->close();

        $this->info("Favicon files have been successfully extracted to: {$publicPath}");
        $this->warn(
            "Check if the contents in the theme blade file at 'views\\partials\\_components\\favicon.blade.php'"
            . " still is the correct HTML to reference these files."
        );

        return 0;
    }

    /**
     * Get the console command arguments.
     *
     * @return array
     */
    protected function getArguments()
    {
        return [
            ['path', InputArgument::REQUIRED, 'The path to the favicon zip file'],
        ];
    }
}
