<?php

namespace Ignite\Core\Entities;

/**
 * Ignite\Core\Entities\Note
 *
 * @property int $id
 * @property string $table_name
 * @property int $table_primary_id
 * @property int $by_user_id
 * @property int $login_user_id
 * @property string $message
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Ignite\Core\Entities\User|null $addedBy
 * @property-read \Ignite\Core\Entities\User $user
 * @method static \Illuminate\Database\Eloquent\Builder|Note newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Note newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Note query()
 * @method static \Illuminate\Database\Eloquent\Builder|Note whereByUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Note whereCreatedAt($value)
 * @method static Builder|Base whereHasPermission(string $permission, ?\Ignite\Core\Entities\User $user = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Note whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Note whereLoginUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Note whereMessage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Note whereTableName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Note whereTablePrimaryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Note whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Note extends Base
{
    /**
     * The custom table name.
     * @var string
     */
    protected $table = 'core_note';

    /**
     * The custom primary key.
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * The relationship to the User.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * The relationship to the user that added the note.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function addedBy()
    {
        return $this->hasOne(User::class, 'user_id', 'by_user_id');
    }
}
