@extends('Core::layouts.main')

@section('meta_title', $title = 'Content Management')

@section('heading')
    <h1>
        @yield('page_heading')
        <small><a href="{{ route('admin.pages.index') }}">{{ $title }}</a></small>
    </h1>
@endsection

@section('breadcrumb')
    @parent
    <li><a href="{{ route('admin.pages.index') }}">CMS</a></li>
    <li class="active">@yield('page_breadcrumb')</li>
@endsection

@section('page_content')
    <div class="row">
        <div class="col-sm-12">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    @can('core.cms.pages.browse')
                        <li class="{{ request()->is('admin/cms/pages*') ? 'active' : '' }}"><a href="{{ route('admin.pages.index') }}">Pages</a></li>
                    @endcan
                    @can('core.cms.blocks.browse')
                        <li class="{{ request()->is('admin/cms/blocks*') ? 'active' : '' }}"><a href="{{ route('admin.blocks.index') }}">Blocks</a></li>
                    @endcan
                    @can('core.cms.media.browse')
                        <li class="{{ request()->is('admin/cms/media*') ? 'active' : '' }}"><a href="{{ route('admin.media.index') }}">Media</a></li>
                    @endcan
                </ul>
                <div class="tab-content @yield('tab_content_class')">
                    @yield('tab_content')
                </div>
            </div>
        </div>
    </div>
@endsection
