<?php

namespace Ignite\Core\Contracts\Entities;

/**
 * User Contract
 *
 * @property bool $exists
 * @property \Ignite\Core\Contracts\Entities\Participant $participant
 */
interface User
{
    /**
     * Get the value of the model's primary key.
     *
     * @return mixed
     */
    public function getKey();

    /**
     * Determine if the given relation is loaded.
     *
     * @param  string  $key
     * @return bool
     */
    public function relationLoaded($key);

    /**
     * Set the given relationship on the model.
     *
     * @see    \Illuminate\Database\Eloquent\Concerns\HasRelationships
     * @param  string  $relation
     * @param  mixed  $value
     * @return $this
     */
    public function setRelation($relation, $value);

    /**
     * Save the model to the database.
     *
     * @param  array  $options
     * @return bool
     */
    public function save(array $options = []);
}
