<?php

namespace Ignite\Core\Validators;

use Illuminate\Contracts\Validation\Validator;

class Amount
{
    /**
     * Validate an amount value.
     *
     * @param  string    $attribute
     * @param  string    $value
     * @param  array     $parameters
     * @param  Validator $validator
     * @return int
     */
    public function validate($attribute, $value, $parameters, $validator)
    {
        return preg_match('/^[+-]?[0-9]{1,3}(?:,?[0-9]{3})*(\.[0-9]{2})?$/', $value);
    }
}
