<div class="file-browser bg-white" style="min-height: 200px" x-data="window.MediaManager()" x-init="init()">
    <div class="box box-default" style="margin-bottom: 0" data-widget="box-widget">
        <div class="box-header with-border no-margin" x-show="!loading">
            <h1 x-on:click="reload()" class="box-title" style="margin: 0 0 0 8px; cursor: pointer">{{ config('core.cms.disk') }}::/{{ config('core.cms.folder') }}</h1>
            <div style="margin-left: 10px;" class="box-tools">
                <div class="has-feedback">
                    <input x-model="keywords" type="text" class="form-control" placeholder="Search files">
                    <span class="fa fa-search form-control-feedback"></span>
                </div>
            </div>
            <div class="box-tools btn-group" x-show="!loading">
                <button class="btn btn-default" tabindex="0" aria-controls="dataTableBuilder" type="button" style="cursor: pointer;">
                    <form enctype="multipart/form-data" autocomplete="off">
                        <label for="file-browser__file-upload" style="font-weight: normal; cursor: pointer; margin: 0">
                            <input x-ref="upload" x-on:change="upload($refs.upload.files)" id="file-browser__file-upload" class="hidden" type="file" name="upload" multiple />
                                <span>
                                    <span class="fa fa-upload text-success"></span>
                                    <span class="text-success">Upload</span>
                                </span>
                        </label>
                    </form>
                </button>
                <button x-on:click.prevent="reload()" class="btn btn-default" type="button">
                    <span class="fa fa-reload"></span>
                    <span>Reload</span>
                </button>
                <button x-on:click.prevent="toggleSelectAll()" class="btn btn-default" type="button">
                    <span x-show="selected.length === 0">Select All</span>
                    <span x-show="selected.length > 0">Deselect All</span>
                </button>
                <button x-on:click.prevent="downloadSelected()" x-bind:disabled="!selected.length" x-bind:class="{'disabled': !selected.length}" class="btn btn-default" type="button">
                    <span class="fa fa-download"></span>
                    <span id="download-selected-label">Download</span>
                </button>
                <button x-show="hasEditor()" x-on:click.prevent.stop="insertSelectedIntoEditor()" x-bind:disabled="!selected.length" x-bind:class="{'disabled': !selected.length}" class="btn btn-default" title="Insert files">
                    <span class="fa fa-plus"></span>
                    <span>Insert</span>
                </button>
                <button x-on:click.prevent="removeSelected()" x-bind:disabled="!selected.length" x-bind:class="{'disabled': !selected.length}" class="btn btn-default" type="button">
                    <span class="fa fa-trash text-danger"></span>
                    <span id="delete-selected-label" class="text-danger">Delete</span>
                </button>
            </div>
        </div>
        <div class="box-header" style="padding: 6px 18px 0;" x-show="!loading">
            <h3 class="box-subtitle no-margin">
                <small class="muted">
                    <span x-text="filteredFiles().length"></span> files
                    <span x-show="keywords.length">matching "<span x-text="keywords"></span>"</span>
                </small>
                <small class="text-primary" x-show="selected.length">
                    (<span x-text="selected.length"></span> <span x-text="countSelected()"></span> selected)
                </small>
            </h3>
        </div>
        <div id="drop-area" class="box-body" x-show="!loading">
            <div id="file-browser-container" class="file-browser__files">
                <template x-for="file in filteredFiles()" :key="file.hash">
                    <div>
                        <div x-bind:data-hash="file.hash" x-on:click.prevent="toggleSelected(file, $event)" x-bind:class="{'file-browser__file--selected': isSelected(file)}" class="file-browser__file">
                            <template x-if="isImage(file)">
                                <img x-bind:src="file.url" x-bind:alt="file.name" class="img-responsive file-browser__file-thumbnail file-browser__file-thumbnail--image" />
                            </template>
                            <template x-if="! isImage(file)">
                                <div class="file-browser__file-thumbnail file-browser__file-thumbnail--document">
                                    <span class="file-browser__file-icon fa fa-file fa-3x"></span>
                                    <span class="file-browser__file-extension" x-text="file.extension"></span>
                                </div>
                            </template>
                            <div class="file-browser__file-info">
                                <h5 class="no-margin" x-bind:title="file.path" x-text="file.name"></h5>
                                <p class="no-margin" x-bind:title="file.size"><small>Size: <span x-text="file.size_formatted"></span></small></p>
                                <p class="no-margin" x-bind:title="file.timestamp"><small>Modified: <span x-text="file.timestamp_formatted"></span></small></p>
                                <div class="file-browser__file-actions">
                                    <div class="btn-group">
                                        <button x-show="isImage(file)" x-on:click.prevent.stop="open(file.url)" type="button" class="btn btn-sm btn-default" title="Open the file in a new tab"><span class="fa fa-eye"></span></button>
                                        <button type="button" x-on:click.prevent.stop="removeFile(file.hash)" class="btn btn-sm btn-default" title="Delete the file forever"><span class="fa fa-trash"></span></button>
                                        <button x-on:click.prevent.stop="clipboard(file.url, $event)" class="btn btn-sm btn-default" title="Copy the file the clipboard"><span class="fa fa-clipboard"></span></button>
                                        <button x-show="hasEditor()" x-on:click.prevent.stop="insertIntoEditor(file)" class="btn btn-sm btn-default" title="Insert file"><span class="fa fa-plus"></span></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
        </div>
        <div class="overlay" x-show="loading">
            <div class="text-center" style="padding-top: 50px; padding-bottom: 50px">
                <i class="fa fa-refresh fa-spin fa-2x"></i>
                <p>Retrieving file list...</p>
            </div>
        </div>
    </div>
</div>
