<?php

namespace Ignite\Core\Services\Google\Analytics\Adapter;

use Google\Collection as GoogleCollection;
use Illuminate\Support\Carbon;

interface AdapterInterface
{
    /**
     * Returns the current total and the previous total as an array.
     *
     * @param GoogleCollection $response A response object
     * @return array
     */
    public function fetchChangingTotals(GoogleCollection $response): array;

    /**
     * Sends a request to Google Analytics API and to return a response object.
     *
     * @param  string      $metricName
     * @param  Carbon      $start
     * @param  Carbon      $end
     * @param  Carbon|null $previousStart
     * @param  Carbon|null $previousEnd
     *
     * @return \Google\Collection A response object
     */
    public function fetchResponse(
        string $metricName,
        Carbon $start,
        Carbon $end,
        Carbon $previousStart = null,
        Carbon $previousEnd = null
    ): GoogleCollection;

    /**
     * From the response, return an array of the data from each day.
     *
     * @param GoogleCollection $response A response object
     * @return array
     */
    public function fetchSeries(GoogleCollection $response, Carbon $start, Carbon $end): array;

    /**
     * Get the single metric value.
     *
     * @param GoogleCollection $response A response object
     * @return float
     */
    public function metricValue(GoogleCollection $response): float;
}
