<?php

namespace Ignite\Core\Tests\Unit\Files\Processors;

use Ignite\Core\Files\File;
use Ignite\Core\Files\Processors\AdhocFileProcessor;
use Ignite\Core\Tests\TestCase;
use Illuminate\Support\Facades\Storage;

class AdhocFileProcessorTest extends TestCase
{
    /** @test */
    public function processes_files_based_on_given_callback()
    {
        // Arrange
        Storage::fake();
        $file = File::new('SomeFile.txt');
        $file->put('some contents!!');
        $adhocFileProcessor = new AdhocFileProcessor(function (File $file) {
            $file->put('other contents!');
            return $file;
        });

        // Execute
        $processedFile = $adhocFileProcessor->run($file);

        // Check
        $this->assertEquals('other contents!', $file->get());
        $this->assertTrue($processedFile->is($file));
    }
}
