<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Entities\Import;
use Illuminate\Database\DatabaseManager;
use Illuminate\Support\Arr;
use Yajra\DataTables\DataTables;

class ImportTable extends EloquentTable
{
    /** @var DataTables */
    protected $datatables;

    /** @var ReportFormatter */
    protected $formatter;

    /**
     * ImportTable constructor.
     *
     * @param DataTables $datatables
     * @param DatabaseManager $databaseManager
     * @param ImportFormatter $formatter
     * @param array $params
     */
    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        ImportFormatter $formatter,
        array $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);
        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'action' => [
                'title' => 'Actions',
                'name' => 'actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'width' => '87px',
                'style' => 'min-width:87px!important;'
            ],
            'status' => [
                'title' => 'Status',
                'name' => 'status',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
                'width' => '110px',
            ],
            'created_at' => [
                'title' => 'Created At',
                'name' => 'created_at',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'created_by' => [
                'title' => 'Created By',
                'name' => 'created_by',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'type' => [
                'title' => 'Type',
                'name' => 'type',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'file' => [
                'title' => 'File',
                'name' => 'file',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'records' => [
                'title' => 'Records',
                'name' => 'records',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'run_at' => [
                'title' => 'Run At',
                'name' => 'run_at',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
            'run_by' => [
                'title' => 'Run By',
                'name' => 'run_by',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ],
        ];
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'action' => [$this->formatter, 'actions'],
            'status' => [$this->formatter, 'statusLabel'],
            'type' => [$this->formatter, 'type'],
            'file' => [$this->formatter, 'file'],
            'created_at' => [$this->formatter, 'createdAt'],
            'created_by' => [$this->formatter, 'createdBy'],
            'run_at' => [$this->formatter, 'runAt'],
            'run_by' => [$this->formatter, 'runBy'],
        ];
    }

    /**
     * The imports query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        return Import::query();
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        return parent::getBuilderParameters([
            'order' => [
                [2, 'desc'] // Created At
            ]
        ]);
    }
}
