<?php

namespace Ignite\Core\Emails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class BatchedEmailSummaryToProgramManager extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var array $data
     */
    private array $data;

    /**
     * SendTransactionSubmittedEmail constructor.
     *
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->data = $data;
    }

    /**
     * When a user submits a new activity event.
     *
     * @return $this
     */
    public function build()
    {
        $data = $this->data;
        $this->to(config('mail.from.address'), config('mail.from.name'));
        $this->subject('Daily Batched Transactions Summary Notifications sent to ' . count($data) . ' users!');
        $this->from(config('mail.from.address'), config('mail.from.name'));

        return $this->markdown('emails.batched-email-summary', compact('data'));
    }
}
