<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'salesforce' => [
        'client_id' => env('SALESFORCE_KEY'),
        'client_secret' => env('SALESFORCE_SECRET'),
        'redirect' => env('SALESFORCE_REDIRECT_URI')
    ],

    'recaptcha' => [
        /* See reCaptcha Documentation
         * https://developers.google.com/recaptcha/docs/versions
         * -------------------------------------------------- //
         * ACCEPTABLE OPTIONS
         *
         * Required
         * - sitekey: <string>
         * - secret:  <string>
         *
         * Optional (not fully implemented -- will be in Core)
         * - version: 2 (default)
         *            3
         * - type:    android
         *            invisible
         *            robot (default) (will update at a later time)
         *            score (version 3 only)
         * -------------------------------------------------- */
        'sitekey' => env('RECAPTCHA_SITEKEY'),
        'secret' => env('RECAPTCHA_SECRET'),
        'version' => env('RECAPTCHA_VERSION', 2),
        'field_type' => env('RECAPTCHA_FIELD_TYPE', 'recaptcha_v2_robot'),
        'field_name' => env('RECAPTCHA_FIELD_NAME', 'g-recaptcha-response'),
    ],

];
